/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.UnreachableException;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.OutBox;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;

class MessageManager {
    private static MessageManager theInstance;
    private static final int POOL_SIZE_DEFAULT = 5;
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_QUEUE_SIZE_DEFAULT = 10000000;
    private OutBox outBox;
    private Thread[] deliverers;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    private MessageManager() {
    }

    public static synchronized MessageManager instance(Profile p) {
        if (theInstance == null) {
            theInstance = new MessageManager();
            theInstance.initialize(p);
        }
        return theInstance;
    }

    public void initialize(Profile p) {
        int poolSize = 5;
        try {
            String tmp = p.getParameter("jade_core_messaging_MessageManager_poolsize", null);
            poolSize = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            // empty catch block
        }
        int maxQueueSize = 10000000;
        try {
            String tmp = p.getParameter("jade_core_messaging_MessageManager_maxqueuesize", null);
            maxQueueSize = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.outBox = new OutBox(maxQueueSize);
        try {
            ResourceManager rm = p.getResourceManager();
            this.deliverers = new Thread[poolSize];
            int i = 0;
            while (i < poolSize) {
                String name = "Deliverer-" + i;
                this.deliverers[i] = rm.getThread(2, name, new Deliverer());
                if (this.myLogger.isLoggable(5)) {
                    this.myLogger.log(5, "Starting deliverer " + name + ". Thread=" + this.deliverers[i]);
                }
                this.deliverers[i].start();
                ++i;
            }
        }
        catch (ProfileException pe) {
            throw new RuntimeException("Can't get ResourceManager. " + pe.getMessage());
        }
    }

    public void deliver(GenericMessage msg, AID receiverID, Channel ch) {
        this.outBox.addLast(receiverID, msg, ch);
    }

    public static final String stringify(GenericMessage m) {
        ACLMessage msg = m.getACLMessage();
        if (msg != null) {
            StringBuffer sb = new StringBuffer("(");
            sb.append(ACLMessage.getPerformative(msg.getPerformative()));
            sb.append(" sender: ");
            sb.append(msg.getSender());
            if (msg.getOntology() != null) {
                sb.append(" ontology: ");
                sb.append(msg.getOntology());
            }
            if (msg.getConversationId() != null) {
                sb.append(" conversation-id: ");
                sb.append(msg.getConversationId());
            }
            sb.append(')');
            return sb.toString();
        }
        return "unavailable";
    }

    String[] getQueueStatus() {
        return this.outBox.getStatus();
    }

    String[] getThreadPoolStatus() {
        String[] status = new String[this.deliverers.length];
        int i = 0;
        while (i < this.deliverers.length) {
            status[i] = "(Deliverer-" + i + " :alive " + this.deliverers[i].isAlive() + ")";
            ++i;
        }
        return status;
    }

    public static class PendingMsg {
        private final GenericMessage msg;
        private final AID receiverID;
        private final Channel channel;
        private long deadline;

        public PendingMsg(GenericMessage msg, AID receiverID, Channel channel, long deadline) {
            this.msg = msg;
            this.receiverID = receiverID;
            this.channel = channel;
            this.deadline = deadline;
        }

        public GenericMessage getMessage() {
            return this.msg;
        }

        public AID getReceiver() {
            return this.receiverID;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public long getDeadline() {
            return this.deadline;
        }

        public void setDeadline(long deadline) {
            this.deadline = deadline;
        }
    }

    class Deliverer
    implements Runnable {
        Deliverer() {
        }

        public void run() {
            while (true) {
                PendingMsg pm = MessageManager.this.outBox.get();
                GenericMessage msg = pm.getMessage();
                AID receiverID = pm.getReceiver();
                Channel ch = pm.getChannel();
                try {
                    ch.deliverNow(msg, receiverID);
                }
                catch (Throwable t) {
                    MessageManager.this.myLogger.log(9, "MessageManager cannot deliver message " + MessageManager.stringify(msg) + " to agent " + receiverID.getName() + ". " + t);
                    ch.notifyFailureToSender(msg, receiverID, new InternalError("\"" + t + "\""));
                }
                MessageManager.this.outBox.handleServed(receiverID);
            }
        }
    }

    public static interface Channel {
        public void deliverNow(GenericMessage var1, AID var2) throws UnreachableException, NotFoundException;

        public void notifyFailureToSender(GenericMessage var1, AID var2, InternalError var3);
    }
}

